# Changelog

## 2.1.1 _(2025-04-14)_
* Change: Discontinue unnecessary explicit loading of textdomain
* Hardening: Ensure translated error message doesn't contain markup
* Change: Note compatibility through WP 6.8+
* Change: Note compatibility through PHP 8.3+
* Change: Update copyright date (2025)
* Unit tests:
    * Change: Use `expectException()` instead of `@expectedException` comment (for PHPUnit 9 support)

## 2.1 _(2024-08-08)_
* Change: Remove the admin bar search field with a higher priority than what it was changed to in WP 6.6.
* Change: Check if core/search block is registered before attempting to unregister. Props toru.
* Change: Note compatibility through WP 6.6+
* Change: Update copyright date (2024)
* Change: Remove development and testing-related files from release packaging
* Unit tests:
    * Hardening: Prevent direct web access to `bootstrap.php`
    * Fix: Define functions now expected by the bundled theme being used
* New: Add some potential TODO items

## 2.0.1 _(2023-09-02)_
* Change: Safeguard JS from throwing error if WP JS isn't loaded (should be rare to never)
* Change: Note compatibility through WP 6.3+
* Change: Update copyright date (2023)
* Change: Tweak code alignment
* New: Add `.gitignore` file
* Unit tests:
    * Fix: Allow tests to run against current versions of WordPress
    * New: Add `composer.json` for PHPUnit Polyfill dependency
    * Change: Prevent PHP warnings due to missing core-related generated files

## 2.0 _(2021-09-13)_

### Highlights:

This release finally addresses disabling the search block, notes compatibility through WP 5.8+, and restructures unit test directories.

### Details:

* New: Disable the search block
    * New: Add `disable_core_search_block()` to unregister block via PHP
    * New: Add `enqueue_block_editor_assets()` to register JS script to unregister search block via JS
    * New: Add JS script file to unregister search block
    * Change: Update documentation to reflect search block being disabled
* Change: Remove `get_search_form()` and simply use `__return_empty_string()` as callback to `'get_search_form'` filter
* Change: Note compatibility through WP 5.8+
* Change: Tweak installation instruction
* Unit tests:
    * Change: Restructure unit test directories
        * Change: Move `phpunit/` into `tests/`
        * Change: Move `phpunit/bin` into `tests/`
    * Change: Remove 'test-' prefix from unit test file
    * Change: In bootstrap, store path to plugin file constant
    * Change: In bootstrap, add backcompat for PHPUnit pre-v6.0

## 1.8.3 _(2021-05-01)_
* Fix: Change `__wakeup()` method visibility from `private` to `public` to avoid warnings under PHP8
* Fix: Throw an error when attempting to unserialize an instance of the class to actually prevent it from happening

## 1.8.2 _(2021-04-08)_
* Change: Note compatibility through WP 5.7+
* Change: Update copyright date (2021)
* Change: Tweak wording and formatting of readme.txt
* New: Add FAQ entry
* New: Add unit tests to verify search is removed from admin bar

## 1.8.1 _(2020-09-07)_
* Change: Restructure unit test file structure
    * New: Create new subdirectory `phpunit/` to house all files related to unit testing
    * Change: Move `bin/` to `phpunit/bin/`
    * Change: Move `tests/bootstrap.php` to `phpunit/`
    * Change: Move `tests/` to `phpunit/tests/`
    * Change: Rename `phpunit.xml` to `phpunit.xml.dist` per best practices
* Change: Note compatibility through WP 5.5+

## 1.8 _(2020-06-02)_
* New: Disable output of `SearchAction` in SEO schema by Yoast SEO. Props @galengidman.
* New: Add TODO.md and move existing TODO list from top of main plugin file into it (and add to it)
* Change: Use HTTPS for link to WP SVN repository in bin script for configuring unit tests
* Change: Note compatibility through WP 5.4+
* Change: Update links to coffee2code.com to be HTTPS
* Unit tests:
    * New: Add tests for hooking actions and filters
    * New: Add test for backend searches not being affected
    * Change: Remove unnecessary unregistering of hooks and thusly delete `tearDown()`

## 1.7.2 _(2019-12-12)_
* Change: Note compatibility through WP 5.3+
* Change: Unit tests: Change method signature of `assertQueryTrue()` to match parent's update to use the spread operator
* Change: Update copyright date (2020)

## 1.7.1 _(2019-06-17)_
* Unit tests:
    * Change: Update unit test install script and bootstrap to use latest WP unit test repo
    * New: Test that the plugin hooks `plugins_loaded` for initialization
* Change: Note compatibility through WP 5.2+
* Change: Add link to CHANGELOG.md in README.md

## 1.7 _(2019-03-27)_
* New: Add CHANGELOG.md file and move all but most recent changelog entries into it
* Change: Initialize plugin on 'plugins_loaded' action instead of on load
* Change: Merge `do_init()` into `init()`
* Unit tests:
    * Fix: Discontinue testing deprecated `is_comments_popup` condition
    * Fix: Use `file_exists()` instead of `locate_template()` to verify presence of file in theme (the latter is unreliable since it is based on constants)
* Change: Note compatibility through WP 5.1+
* Change: Add README.md link to plugin's page in Plugin Directory
* Change: Update copyright date (2019)
* Change: Update License URI to be HTTPS
* Change: Split paragraph in README.md's "Support" section into two

## 1.6.1 _(2018-05-19)_
* New: Add README.md
* New: Add FAQ indicating that the plugin is GDPR-compliant
* Unit tests:
    * Change: Make local copy of `assertQueryTrue()`; apparently it's (now?) a test-specific assertion and not a globally aware assertion
    * Change: Enable and update `test_no_search_form_appears_even_if_searchform_php_exists()` to use TwentySeventeen theme, since it has searchform.php
    * Change: Minor whitespace tweaks to bootstrap
* Change: Add GitHub link to readme
* Change: Note compatibility through WP 4.9+
* Change: Update copyright date (2018)
* Change: Update installation instruction to prefer built-in installer over .zip file

## 1.6 _(2017-02-21)_
* New: Disable search item from front-end admin bar
* Change: Prevent object instantiation
    * Add private `__construct()`
    * Add private `__wakeup()`
* Change: Update unit test bootstrap
    * Default `WP_TESTS_DIR` to `/tmp/wordpress-tests-lib` rather than erroring out if not defined via environment variable
    * Enable more error output for unit tests
* Change: Note compatibility through WP 4.7+
* Change: Remove support for WordPress older than 4.6 (should still work for earlier versions back to WP 3.6)
* Change: Update copyright date (2017)
* New: Add LICENSE file

## 1.5.1 _(2016-01-15)_
* Bugfix: Declare `do_init()` as public.

## 1.5 _(2016-01-14)_
* Add: Set 404 HTTP status header for disabled search requests.
* Add: Define 'Text Domain' in plugin header and load it.
* Add: Create empty index.php to prevent files from being listed if web server has enabled directory listings.
* Change: Perform all hook registering during plugins_loaded action.
* Change: Explicitly declare methods in unit tests as public.
* Change: Note compatibility through WP 4.4+.
* Change: Update copyright date (2016).

## 1.4.2 _(2015-08-23)_
* Change: Note compatibility through WP 4.3+.
* Change: Minor inline docs changes.

## 1.4.1 _(2015-02-15)_
* Add trivial unit tests for plugin version and class name
* Note compatibility through WP 4.1+
* Update copyright date (2015)
* Add plugin icon

## 1.4 _(2013-12-15)_
* Change to hook `get_search_form` at lower priority so it runs after anything else also using the filter
* Change to only affect main query
* Remove admin nag for alerting about the presence of searchform.php in a theme since this no longer matters
* Add unit tests
* Note compatibility through WP 3.8+
* Change minimum required compatibility to WP 3.6
* Update copyright date (2014)
* Add banner
* Many changes to readme.txt documentation (namely to pare out a lot of stuff relating to suppression of searchform.php which has since been made possible in WP core)
* Change description
* Change donate link

## 1.3.1 _(unreleased)_
* Don't show searchform.php admin nag if user doesn't have `edit_themes` cap
* Add check to prevent execution of code if file is directly accessed
* Re-license as GPLv2 or later (from X11)
* Add 'License' and 'License URI' header tags to readme.txt and plugin file
* Remove ending PHP close tag
* Note compatibility through WP 3.5+
* Update copyright date (2013)

## 1.3
* Add notice to main themes and plugins admin pages if active theme has searchform.php template
* Note compatibility through WP 3.3+
* Add `version()` to return plugin version
* Add more documentation and FAQ questions to readme.txt
* Add link to plugin directory page to readme.txt
* Update copyright date (2012)

## 1.2.1
* Note compatibility through WP 3.2+
* Tiny code formatting change (spacing)
* Fix plugin homepage and author links in description in readme.txt

## 1.2
* Switch from object instantiation to direct class function invocation
* Explicitly declare all functions public static
* Add development note
* Add additional FAQ question
* Note compatibility through WP 3.1+
* Update copyright date (2011)

## 1.1.1
* Fix disabling of search widget
* Move class instantiation inside of `if(!class_exists())` check
* Rename class from `DisableSearch` to `c2c_DisableSearch`
* Store object instance in global variable `c2c_disable_search` for possible external manipulation
* Note compatibility with WP 3.0+
* Minor code reformatting (spacing)
* Remove documentation and instructions from top of plugin file (all of that and more are contained in readme.txt)
* Add Upgrade Notice section to readme.txt

## 1.1
* Disable/unregister search widget
* Add PHPDoc documentation
* Minor formatting tweaks
* Note compatibility with WP 2.9+
* Drop compatibility with WP older than 2.8
* Update copyright date
* Update readme.txt (including adding Changelog)

## 1.0
* Initial release
