jQuery(document).ready(function($) {
    const dropZone = $('#td-drop-zone');
    const fileInput = $('#td-file-input');
    const fileSelect = $('#td-file-select');
    const uploadProgress = $('#td-upload-progress');
    const progressFill = $('.td-progress-fill');
    
    // Gérer le bouton de sélection de fichier
    fileSelect.on('click', function() {
        fileInput.click();
    });
    
    // Gérer la sélection de fichier
    fileInput.on('change', function() {
        const files = this.files;
        if (files.length > 0) {
            td_handleFileUpload(files[0]);
        }
    });
    
    // Gérer le drag & drop
    dropZone.on('dragover', function(e) {
        e.preventDefault();
        e.stopPropagation();
        $(this).addClass('td-dragover');
    });
    
    dropZone.on('dragleave', function(e) {
        e.preventDefault();
        e.stopPropagation();
        $(this).removeClass('td-dragover');
    });
    
    dropZone.on('drop', function(e) {
        e.preventDefault();
        e.stopPropagation();
        $(this).removeClass('td-dragover');
        
        const files = e.originalEvent.dataTransfer.files;
        if (files.length > 0) {
            td_handleFileUpload(files[0]);
        }
    });
    
    // Gérer l'upload des fichiers
    function td_handleFileUpload(file, replace = false) {
        // Vérifier le type de fichier
        if (!file.name.toLowerCase().endsWith('.csv')) {
            alert(tdArchives.messages.invalid_file);
            return;
        }
        
        const formData = new FormData();
        formData.append('action', 'td_upload_csv');
        formData.append('nonce', tdArchives.nonce);
        formData.append('csv_file', file);
        
        if (replace) {
            formData.append('replace', '1');
        }
        
        uploadProgress.show();
        progressFill.css('width', '0%');
        
        // Désactiver la zone de drop pendant l'upload
        dropZone.addClass('td-uploading');
        
        $.ajax({
            url: tdArchives.ajaxurl,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            xhr: function() {
                const xhr = new XMLHttpRequest();
                xhr.upload.addEventListener('progress', function(e) {
                    if (e.lengthComputable) {
                        const percentComplete = (e.loaded / e.total) * 100;
                        progressFill.css('width', percentComplete + '%');
                    }
                });
                return xhr;
            },
            success: function(response) {
                uploadProgress.hide();
                dropZone.removeClass('td-uploading');
                
                if (response.success) {
                    td_showNotice(response.data.message, 'success');
                    fileInput.val(''); // Reset input
                    
                    // Rediriger vers la liste après 2 secondes
                    setTimeout(function() {
                        window.location.href = response.data.redirect;
                    }, 2000);
                    
                } else if (response.status === 'exists') {
                    if (confirm(tdArchives.messages.file_exists)) {
                        td_handleFileUpload(file, true);
                    } else {
                        fileInput.val('');
                    }
                } else {
                    td_showNotice(response.data || tdArchives.messages.upload_error, 'error');
                }
            },
            error: function() {
                uploadProgress.hide();
                dropZone.removeClass('td-uploading');
                td_showNotice(tdArchives.messages.upload_error, 'error');
            }
        });
    }
    
    // Supprimer un fichier CSV
    $(document).on('click', '.td-delete-csv', function() {
        const filename = $(this).data('file');
        const redirect = $(this).data('redirect');
        
        if (!confirm(tdArchives.messages.delete_confirm)) {
            return;
        }
        
        // Désactiver le bouton pendant la suppression
        const $button = $(this);
        $button.prop('disabled', true).text('Suppression...');
        
        $.ajax({
            url: tdArchives.ajaxurl,
            type: 'POST',
            data: {
                action: 'td_delete_csv',
                nonce: tdArchives.nonce,
                filename: filename,
                redirect: redirect
            },
            success: function(response) {
                if (response.success) {
                    td_showNotice(response.data.message, 'success');
                    
                    if (response.data.redirect) {
                        // Rediriger vers la liste
                        setTimeout(function() {
                            window.location.href = response.data.redirect;
                        }, 1500);
                    } else {
                        // Supprimer la carte du fichier
                        $button.closest('.td-file-card').fadeOut(function() {
                            $(this).remove();
                        });
                    }
                } else {
                    $button.prop('disabled', false).text('Supprimer');
                    td_showNotice(response.data || 'Erreur lors de la suppression', 'error');
                }
            },
            error: function() {
                $button.prop('disabled', false).text('Supprimer');
                td_showNotice('Erreur lors de la suppression', 'error');
            }
        });
    });
    
    // Afficher une notification
    function td_showNotice(message, type) {
        // Supprimer les anciennes notifications
        $('.notice').remove();
        
        const noticeClass = type === 'success' ? 'notice-success' : 'notice-error';
        const notice = $('<div class="notice ' + noticeClass + ' is-dismissible"><p>' + message + '</p><button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>');
        
        $('.wrap h1').after(notice);
        
        // Auto-remove après 5 secondes
        setTimeout(function() {
            notice.fadeOut(function() {
                $(this).remove();
            });
        }, 5000);
        
        // Gérer le bouton de fermeture
        notice.on('click', '.notice-dismiss', function() {
            notice.remove();
        });
    }
    
    // Animation des cartes de fichiers au hover
    $('.td-file-card').on('mouseenter', function() {
        $(this).addClass('td-hover');
    }).on('mouseleave', function() {
        $(this).removeClass('td-hover');
    });
    
    // Scroll vers le haut après pagination
    if (window.location.href.indexOf('paged=') > -1) {
        $('html, body').animate({
            scrollTop: $('.wrap').offset().top - 32
        }, 500);
    }

    // Gestion des clics sur les tags de colonnes (page options)
    $(document).on('click', '.td-column-tag', function() {
        const columnName = $(this).text();
        const textarea = $('#td_hidden_columns');
        const currentValue = textarea.val().trim();
        
        // Vérifier si la colonne n'est pas déjà dans la liste
        const lines = currentValue.split('\n');
        const isAlreadyAdded = lines.some(line => {
            const columns = line.split(',').map(col => col.trim());
            return columns.includes(columnName);
        });
        
        if (!isAlreadyAdded) {
            // Ajouter la colonne à la fin
            const newValue = currentValue ? currentValue + '\n' + columnName : columnName;
            textarea.val(newValue);
            
            // Animation visuelle
            $(this).addClass('td-tag-added');
            setTimeout(() => {
                $(this).removeClass('td-tag-added');
            }, 1000);
            
            // Notification
            td_showNotice('Colonne "' + columnName + '" ajoutée à la liste', 'success');
        } else {
            td_showNotice('Cette colonne est déjà dans la liste', 'error');
        }
    });

});


