(function(blocks, element, blockEditor) {
    const el = element.createElement;
    const registerBlockType = blocks.registerBlockType;
    const useBlockProps = blockEditor.useBlockProps;

    // Bloc : Liste complète des rencontres
    registerBlockType('td-rencontres/liste-rencontres', {
        title: 'Liste des rencontres',
        icon: 'list-view',
        category: 'widgets',
        attributes: {
            categorie: {
                type: 'string',
                default: 'all'
            },
            ordre: {
                type: 'string',
                default: 'desc'
            }
        },
        edit: function(props) {
            const blockProps = useBlockProps();
            return el('div', blockProps,
                el('div', { 
                    style: { 
                        padding: '20px', 
                        background: '#f0f0f0', 
                        border: '2px dashed #999',
                        textAlign: 'center'
                    } 
                },
                    el('p', { style: { margin: 0, fontWeight: 'bold' } }, '📋 Liste des rencontres'),
                    el('p', { style: { margin: '10px 0 0 0', fontSize: '14px', color: '#666' } }, 'Affiche toutes les rencontres avec filtres')
                )
            );
        },
        save: function() {
            return null;
        }
    });

    // Bloc : Dernières rencontres passées
    registerBlockType('td-rencontres/dernieres-passees', {
        title: 'Dernières rencontres passées',
        icon: 'archive',
        category: 'widgets',
        edit: function(props) {
            const blockProps = useBlockProps();
            return el('div', blockProps,
                el('div', { 
                    style: { 
                        padding: '20px', 
                        background: '#e3f2fd', 
                        border: '2px dashed #1976d2',
                        textAlign: 'center'
                    } 
                },
                    el('p', { style: { margin: 0, fontWeight: 'bold' } }, '📚 Dernières rencontres passées'),
                    el('p', { style: { margin: '10px 0 0 0', fontSize: '14px', color: '#666' } }, 'Affiche les 3 dernières rencontres en colonnes')
                )
            );
        },
        save: function() {
            return null;
        }
    });

    // Bloc : Aperçu prochaine rencontre
    registerBlockType('td-rencontres/prochaine-apercu', {
        title: 'Aperçu prochaine rencontre',
        icon: 'calendar-alt',
        category: 'widgets',
        edit: function(props) {
            const blockProps = useBlockProps();
            return el('div', blockProps,
                el('div', { 
                    style: { 
                        padding: '20px', 
                        background: 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)', 
                        border: '2px dashed #fff',
                        textAlign: 'center',
                        color: '#fff'
                    } 
                },
                    el('p', { style: { margin: 0, fontWeight: 'bold' } }, '⏰ Aperçu prochaine rencontre'),
                    el('p', { style: { margin: '10px 0 0 0', fontSize: '14px' } }, 'Affiche un aperçu de la prochaine rencontre')
                )
            );
        },
        save: function() {
            return null;
        }
    });

    // Bloc : Détail prochaine rencontre
    registerBlockType('td-rencontres/prochaine-detail', {
        title: 'Détail prochaine rencontre',
        icon: 'media-document',
        category: 'widgets',
        edit: function(props) {
            const blockProps = useBlockProps();
            return el('div', blockProps,
                el('div', { 
                    style: { 
                        padding: '20px', 
                        background: '#f3e5f5', 
                        border: '2px dashed #9c27b0',
                        textAlign: 'center'
                    } 
                },
                    el('p', { style: { margin: 0, fontWeight: 'bold' } }, '📄 Détail prochaine rencontre'),
                    el('p', { style: { margin: '10px 0 0 0', fontSize: '14px', color: '#666' } }, 'Affiche tous les détails de la prochaine rencontre')
                )
            );
        },
        save: function() {
            return null;
        }
    });

})(
    window.wp.blocks,
    window.wp.element,
    window.wp.blockEditor
);
