<?php
// Bloc : Aperçu des 3 dernières rencontres passées

function td_rencontres_register_dernieres_passees_block() {
    if (!function_exists('register_block_type')) {
        return;
    }
    
    register_block_type('td-rencontres/dernieres-passees', array(
        'render_callback' => 'td_rencontres_render_dernieres_passees_block'
    ));
}
add_action('init', 'td_rencontres_register_dernieres_passees_block');

function td_rencontres_render_dernieres_passees_block($attributes) {
    $args = array(
        'post_type' => 'rencontre',
        'posts_per_page' => 3,
        'post_status' => 'publish',
        'meta_query' => array(
            array(
                'key' => '_td_statut',
                'value' => 'passee',
                'compare' => '='
            )
        ),
        'meta_key' => '_td_date_evenement',
        'orderby' => 'meta_value',
        'order' => 'DESC'
    );
    
    $rencontres = new WP_Query($args);
    
    if (!$rencontres->have_posts()) {
        return '<p class="td-rencontres-vide">Aucune rencontre passée pour le moment.</p>';
    }
    
    ob_start();
    ?>
    <div class="td-dernieres-passees">
        <h2 class="td-dernieres-passees-titre">Dernières rencontres</h2>
        
        <div class="td-dernieres-passees-grille">
            <?php
            while ($rencontres->have_posts()) {
                $rencontres->the_post();
                $post_id = get_the_ID();
                $date_evenement = get_post_meta($post_id, '_td_date_evenement', true);
                $lieu = get_post_meta($post_id, '_td_lieu', true);
                $nb_participants = get_post_meta($post_id, '_td_nb_participants', true);
                $nb_laboratoires = get_post_meta($post_id, '_td_nb_laboratoires', true);
                $terms = get_the_terms($post_id, 'categorie_rencontre');
                $categorie_name = $terms && !is_wp_error($terms) ? $terms[0]->name : '';
                ?>
                <article class="td-passee-item">
                    <?php if (has_post_thumbnail()) : ?>
                        <div class="td-passee-image">
                            <a href="<?php the_permalink(); ?>">
                                <?php the_post_thumbnail('medium'); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    
                    <div class="td-passee-content">
                        <?php if ($categorie_name) : ?>
                            <span class="td-passee-categorie"><?php echo esc_html($categorie_name); ?></span>
                        <?php endif; ?>
                        
                        <h3 class="td-passee-title">
                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                        </h3>
                        
                        <?php if ($date_evenement) : ?>
                            <p class="td-passee-date">
                                📅 <?php echo date_i18n('d/m/Y', strtotime($date_evenement)); ?>
                            </p>
                        <?php endif; ?>
                        
                        <?php if ($lieu) : ?>
                            <p class="td-passee-lieu">
                                📍 <?php echo esc_html($lieu); ?>
                            </p>
                        <?php endif; ?>
                        
                        <div class="td-passee-stats">
                            <?php if ($nb_participants) : ?>
                                <span class="td-passee-stat">
                                    <strong><?php echo esc_html($nb_participants); ?></strong> participants
                                </span>
                            <?php endif; ?>
                            
                            <?php if ($nb_laboratoires) : ?>
                                <span class="td-passee-stat">
                                    <strong><?php echo esc_html($nb_laboratoires); ?></strong> laboratoires
                                </span>
                            <?php endif; ?>
                        </div>
                        
                        <a href="<?php the_permalink(); ?>" class="td-passee-lien">Voir le compte-rendu →</a>
                    </div>
                </article>
                <?php
            }
            wp_reset_postdata();
            ?>
        </div>
    </div>
    
    <style>
        .td-dernieres-passees {
            margin: 40px 0;
        }
        
        .td-dernieres-passees-titre {
            font-size: 28px;
            margin-bottom: 30px;
            text-align: center;
        }
        
        @media (max-width: 999px) {
            .td-dernieres-passees-titre {
                font-size: 24px;
            }
        }
        
        .td-dernieres-passees-grille {
            display: grid;
            gap: 20px;
            grid-template-columns: 1fr;
        }
        
        @media (min-width: 1000px) {
            .td-dernieres-passees-grille {
                grid-template-columns: repeat(3, 1fr);
            }
        }
        
        .td-passee-item {
            border: 1px solid #ddd;
            border-radius: 8px;
            overflow: hidden;
            background: #fff;
            transition: transform 0.3s, box-shadow 0.3s;
        }
        
        .td-passee-item:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 20px rgba(0,0,0,0.15);
        }
        
        .td-passee-image {
            position: relative;
            overflow: hidden;
        }
        
        .td-passee-image img {
            width: 100%;
            height: 200px;
            object-fit: cover;
            transition: transform 0.3s;
        }
        
        .td-passee-item:hover .td-passee-image img {
            transform: scale(1.05);
        }
        
        .td-passee-content {
            padding: 20px;
        }
        
        .td-passee-categorie {
            display: inline-block;
            padding: 4px 10px;
            background: #e3f2fd;
            color: #1976d2;
            border-radius: 4px;
            font-size: 12px;
            font-weight: bold;
            margin-bottom: 10px;
        }
        
        .td-passee-title {
            font-size: 18px;
            margin: 10px 0;
            line-height: 1.3;
        }
        
        @media (max-width: 999px) {
            .td-passee-title {
                font-size: 16px;
            }
        }
        
        .td-passee-title a {
            color: #333;
            text-decoration: none;
        }
        
        .td-passee-title a:hover {
            color: #1976d2;
        }
        
        .td-passee-date,
        .td-passee-lieu {
            font-size: 14px;
            color: #666;
            margin: 5px 0;
        }
        
        .td-passee-stats {
            display: flex;
            gap: 15px;
            margin: 15px 0;
            padding: 10px 0;
            border-top: 1px solid #eee;
            border-bottom: 1px solid #eee;
            flex-wrap: wrap;
        }
        
        .td-passee-stat {
            font-size: 13px;
            color: #666;
        }
        
        .td-passee-stat strong {
            color: #1976d2;
            font-size: 16px;
        }
        
        .td-passee-lien {
            display: inline-block;
            color: #1976d2;
            text-decoration: none;
            font-weight: bold;
            font-size: 14px;
            margin-top: 10px;
            transition: color 0.3s;
        }
        
        .td-passee-lien:hover {
            color: #1565c0;
        }
    </style>
    <?php
    
    return ob_get_clean();
}
