<?php
// Bloc : Aperçu de la prochaine rencontre

function td_rencontres_register_prochaine_apercu_block() {
    if (!function_exists('register_block_type')) {
        return;
    }
    
    register_block_type('td-rencontres/prochaine-apercu', array(
        'render_callback' => 'td_rencontres_render_prochaine_apercu_block'
    ));
}
add_action('init', 'td_rencontres_register_prochaine_apercu_block');

function td_rencontres_render_prochaine_apercu_block($attributes) {
    $args = array(
        'post_type' => 'rencontre',
        'posts_per_page' => 1,
        'post_status' => 'publish',
        'meta_query' => array(
            array(
                'key' => '_td_statut',
                'value' => 'a_venir',
                'compare' => '='
            )
        ),
        'meta_key' => '_td_date_evenement',
        'orderby' => 'meta_value',
        'order' => 'ASC'
    );
    
    $rencontre = new WP_Query($args);
    
    if (!$rencontre->have_posts()) {
        return '<div class="td-prochaine-apercu td-prochaine-vide"><p class="td-pas-de-rencontre">Pas de rencontre prévue pour le moment</p></div>';
    }
    
    ob_start();
    
    while ($rencontre->have_posts()) {
        $rencontre->the_post();
        $post_id = get_the_ID();
        $date_evenement = get_post_meta($post_id, '_td_date_evenement', true);
        $lieu = get_post_meta($post_id, '_td_lieu', true);
        $responsable = get_post_meta($post_id, '_td_responsable', true);
        $url_sciencesconf = get_post_meta($post_id, '_td_url_sciencesconf', true);
        $terms = get_the_terms($post_id, 'categorie_rencontre');
        $categorie_name = $terms && !is_wp_error($terms) ? $terms[0]->name : '';
        
        // Calculer le nombre de jours restants
        $jours_restants = '';
        if ($date_evenement) {
            $date_event = strtotime($date_evenement);
            $date_aujourdhui = strtotime(date('Y-m-d'));
            $diff_jours = floor(($date_event - $date_aujourdhui) / (60 * 60 * 24));
            
            if ($diff_jours === 0) {
                $jours_restants = 'Aujourd\'hui';
            } elseif ($diff_jours === 1) {
                $jours_restants = 'Demain';
            } elseif ($diff_jours > 1) {
                $jours_restants = 'Dans ' . $diff_jours . ' jours';
            }
        }
        ?>
        <div class="td-prochaine-apercu">
            <div class="td-prochaine-apercu-inner">
                <?php if (has_post_thumbnail()) : ?>
                    <div class="td-prochaine-apercu-image">
                        <a href="<?php the_permalink(); ?>">
                            <?php the_post_thumbnail('large'); ?>
                        </a>
                    </div>
                <?php endif; ?>
                
                <div class="td-prochaine-apercu-content">
                    <div class="td-prochaine-apercu-header">
                        <span class="td-prochaine-badge">Prochaine rencontre</span>
                        <?php if ($jours_restants) : ?>
                            <span class="td-prochaine-countdown"><?php echo esc_html($jours_restants); ?></span>
                        <?php endif; ?>
                    </div>
                    
                    <?php if ($categorie_name) : ?>
                        <span class="td-prochaine-categorie"><?php echo esc_html($categorie_name); ?></span>
                    <?php endif; ?>
                    
                    <h2 class="td-prochaine-title">
                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </h2>
                    
                    <div class="td-prochaine-infos">
                        <?php if ($date_evenement) : ?>
                            <div class="td-prochaine-info">
                                <span class="td-prochaine-icon">📅</span>
                                <strong>Date :</strong> <?php echo date_i18n('d/m/Y', strtotime($date_evenement)); ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($lieu) : ?>
                            <div class="td-prochaine-info">
                                <span class="td-prochaine-icon">📍</span>
                                <strong>Lieu :</strong> <?php echo esc_html($lieu); ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($responsable) : ?>
                            <div class="td-prochaine-info">
                                <span class="td-prochaine-icon">👤</span>
                                <strong>Responsable :</strong> <?php echo esc_html($responsable); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="td-prochaine-actions">
                        <a href="<?php the_permalink(); ?>" class="td-btn td-btn-primary">Voir les détails</a>
                        <?php if ($url_sciencesconf) : ?>
                            <a href="<?php echo esc_url($url_sciencesconf); ?>" target="_blank" rel="noopener" class="td-btn td-btn-secondary">Page SciencesConf</a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        
        <style>
            .td-prochaine-apercu {
                margin: 40px 0;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                border-radius: 12px;
                padding: 30px;
                color: #fff;
            }
            
            .td-prochaine-vide {
                background: #f5f5f5;
                color: #666;
            }
            
            .td-pas-de-rencontre {
                text-align: center;
                font-size: 18px;
                font-style: italic;
                margin: 0;
            }
            
            .td-prochaine-apercu-inner {
                display: grid;
                gap: 30px;
                align-items: center;
                grid-template-columns: 1fr;
            }
            
            @media (min-width: 1000px) {
                .td-prochaine-apercu-inner {
                    grid-template-columns: 1fr 1.5fr;
                }
            }
            
            .td-prochaine-apercu-image {
                border-radius: 8px;
                overflow: hidden;
                box-shadow: 0 10px 30px rgba(0,0,0,0.3);
            }
            
            .td-prochaine-apercu-image img {
                width: 100%;
                height: auto;
                display: block;
                transition: transform 0.3s;
            }
            
            .td-prochaine-apercu-image:hover img {
                transform: scale(1.05);
            }
            
            .td-prochaine-apercu-header {
                display: flex;
                gap: 15px;
                margin-bottom: 15px;
                flex-wrap: wrap;
                align-items: center;
            }
            
            .td-prochaine-badge {
                display: inline-block;
                padding: 6px 12px;
                background: rgba(255,255,255,0.2);
                border-radius: 4px;
                font-size: 12px;
                font-weight: bold;
                text-transform: uppercase;
                letter-spacing: 1px;
            }
            
            .td-prochaine-countdown {
                display: inline-block;
                padding: 6px 12px;
                background: rgba(255,255,255,0.9);
                color: #667eea;
                border-radius: 4px;
                font-size: 14px;
                font-weight: bold;
            }
            
            .td-prochaine-categorie {
                display: inline-block;
                padding: 4px 10px;
                background: rgba(255,255,255,0.15);
                border-radius: 4px;
                font-size: 12px;
                font-weight: bold;
                margin-bottom: 10px;
            }
            
            .td-prochaine-title {
                font-size: 32px;
                margin: 15px 0;
                line-height: 1.2;
                font-weight: 700;
            }
            
            @media (max-width: 999px) {
                .td-prochaine-title {
                    font-size: 24px;
                }
            }
            
            .td-prochaine-title a {
                color: #fff;
                text-decoration: none;
            }
            
            .td-prochaine-title a:hover {
                text-decoration: underline;
            }
            
            .td-prochaine-infos {
                margin: 20px 0;
            }
            
            .td-prochaine-info {
                display: flex;
                align-items: center;
                gap: 10px;
                margin: 10px 0;
                font-size: 16px;
            }
            
            @media (max-width: 999px) {
                .td-prochaine-info {
                    font-size: 14px;
                }
            }
            
            .td-prochaine-icon {
                font-size: 20px;
            }
            
            .td-prochaine-actions {
                display: flex;
                gap: 15px;
                margin-top: 25px;
                flex-wrap: wrap;
            }
            
            .td-prochaine-apercu .td-btn {
                display: inline-block;
                padding: 12px 24px;
                text-decoration: none;
                border-radius: 6px;
                font-size: 14px;
                font-weight: bold;
                transition: all 0.3s;
                text-align: center;
            }
            
            .td-prochaine-apercu .td-btn-primary {
                background: #fff;
                color: #667eea;
            }
            
            .td-prochaine-apercu .td-btn-primary:hover {
                background: #f0f0f0;
                transform: translateY(-2px);
                box-shadow: 0 4px 12px rgba(0,0,0,0.2);
            }
            
            .td-prochaine-apercu .td-btn-secondary {
                background: rgba(255,255,255,0.2);
                color: #fff;
                border: 2px solid #fff;
            }
            
            .td-prochaine-apercu .td-btn-secondary:hover {
                background: rgba(255,255,255,0.3);
                transform: translateY(-2px);
            }
        </style>
        <?php
    }
    wp_reset_postdata();
    
    return ob_get_clean();
}
