<?php
// Bloc : Détail complet de la prochaine rencontre

function td_rencontres_register_prochaine_detail_block() {
    if (!function_exists('register_block_type')) {
        return;
    }
    
    register_block_type('td-rencontres/prochaine-detail', array(
        'render_callback' => 'td_rencontres_render_prochaine_detail_block'
    ));
}
add_action('init', 'td_rencontres_register_prochaine_detail_block');

function td_rencontres_render_prochaine_detail_block($attributes) {
    $args = array(
        'post_type' => 'rencontre',
        'posts_per_page' => 1,
        'post_status' => 'publish',
        'meta_query' => array(
            array(
                'key' => '_td_statut',
                'value' => 'a_venir',
                'compare' => '='
            )
        ),
        'meta_key' => '_td_date_evenement',
        'orderby' => 'meta_value',
        'order' => 'ASC'
    );
    
    $rencontre = new WP_Query($args);
    
    if (!$rencontre->have_posts()) {
        return '<div class="td-prochaine-detail-vide"><p>Aucune rencontre à venir pour le moment.</p></div>';
    }
    
    ob_start();
    
    while ($rencontre->have_posts()) {
        $rencontre->the_post();
        $post_id = get_the_ID();
        $date_evenement = get_post_meta($post_id, '_td_date_evenement', true);
        $lieu = get_post_meta($post_id, '_td_lieu', true);
        $responsable = get_post_meta($post_id, '_td_responsable', true);
        $url_sciencesconf = get_post_meta($post_id, '_td_url_sciencesconf', true);
        $nb_participants = get_post_meta($post_id, '_td_nb_participants', true);
        $nb_laboratoires = get_post_meta($post_id, '_td_nb_laboratoires', true);
        $programme_id = get_post_meta($post_id, '_td_programme', true);
        $terms = get_the_terms($post_id, 'categorie_rencontre');
        $categorie_name = $terms && !is_wp_error($terms) ? $terms[0]->name : '';
        
        // Calculer le nombre de jours restants
        $jours_restants = '';
        if ($date_evenement) {
            $date_event = strtotime($date_evenement);
            $date_aujourdhui = strtotime(date('Y-m-d'));
            $diff_jours = floor(($date_event - $date_aujourdhui) / (60 * 60 * 24));
            
            if ($diff_jours === 0) {
                $jours_restants = 'C\'est aujourd\'hui !';
            } elseif ($diff_jours === 1) {
                $jours_restants = 'C\'est demain !';
            } elseif ($diff_jours > 1) {
                $jours_restants = 'Dans ' . $diff_jours . ' jours';
            }
        }
        ?>
        <article class="td-prochaine-detail">
            <div class="td-detail-header">
                <div class="td-detail-header-content">
                    <div class="td-detail-badges">
                        <?php if ($categorie_name) : ?>
                            <span class="td-detail-categorie"><?php echo esc_html($categorie_name); ?></span>
                        <?php endif; ?>
                        <span class="td-detail-statut">À venir</span>
                    </div>
                    
                    <h1 class="td-detail-title"><?php the_title(); ?></h1>
                    
                    <?php if ($jours_restants) : ?>
                        <div class="td-detail-countdown">
                            <span class="td-countdown-label">⏰</span>
                            <span class="td-countdown-value"><?php echo esc_html($jours_restants); ?></span>
                        </div>
                    <?php endif; ?>
                </div>
                
                <?php if (has_post_thumbnail()) : ?>
                    <div class="td-detail-image">
                        <?php the_post_thumbnail('large'); ?>
                    </div>
                <?php endif; ?>
            </div>
            
            <div class="td-detail-body">
                <div class="td-detail-main">
                    <div class="td-detail-section">
                        <h2 class="td-detail-section-title">Description</h2>
                        <div class="td-detail-content">
                            <?php the_content(); ?>
                        </div>
                    </div>
                    
                    <?php if ($programme_id) : 
                        $programme_url = wp_get_attachment_url($programme_id);
                        $mime_type = get_post_mime_type($programme_id);
                    ?>
                        <div class="td-detail-section">
                            <h2 class="td-detail-section-title">Programme</h2>
                            <div class="td-detail-programme">
                                <?php if (strpos($mime_type, 'image') !== false) : ?>
                                    <a href="<?php echo esc_url($programme_url); ?>" target="_blank">
                                        <img src="<?php echo esc_url($programme_url); ?>" alt="Programme">
                                    </a>
                                <?php else : ?>
                                    <a href="<?php echo esc_url($programme_url); ?>" target="_blank" class="td-programme-pdf">
                                        <span class="td-pdf-icon">📄</span>
                                        <span class="td-pdf-text">Télécharger le programme (PDF)</span>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                
                <aside class="td-detail-sidebar">
                    <div class="td-detail-info-box">
                        <h3 class="td-info-box-title">Informations pratiques</h3>
                        
                        <?php if ($date_evenement) : ?>
                            <div class="td-info-item">
                                <span class="td-info-icon">📅</span>
                                <div class="td-info-content">
                                    <strong>Date</strong>
                                    <span><?php echo date_i18n('d/m/Y', strtotime($date_evenement)); ?></span>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($lieu) : ?>
                            <div class="td-info-item">
                                <span class="td-info-icon">📍</span>
                                <div class="td-info-content">
                                    <strong>Lieu</strong>
                                    <span><?php echo esc_html($lieu); ?></span>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($responsable) : ?>
                            <div class="td-info-item">
                                <span class="td-info-icon">👤</span>
                                <div class="td-info-content">
                                    <strong>Responsable</strong>
                                    <span><?php echo esc_html($responsable); ?></span>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <?php if ($nb_participants || $nb_laboratoires) : ?>
                        <div class="td-detail-stats-box">
                            <h3 class="td-info-box-title">Statistiques prévues</h3>
                            
                            <?php if ($nb_participants) : ?>
                                <div class="td-stat-item">
                                    <span class="td-stat-number"><?php echo esc_html($nb_participants); ?></span>
                                    <span class="td-stat-label">Participants attendus</span>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($nb_laboratoires) : ?>
                                <div class="td-stat-item">
                                    <span class="td-stat-number"><?php echo esc_html($nb_laboratoires); ?></span>
                                    <span class="td-stat-label">Laboratoires représentés</span>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    
                    <?php if ($url_sciencesconf) : ?>
                        <a href="<?php echo esc_url($url_sciencesconf); ?>" target="_blank" rel="noopener" class="td-detail-btn">
                            Accéder à la page SciencesConf
                        </a>
                    <?php endif; ?>
                </aside>
            </div>
        </article>
        
        <style>
            .td-prochaine-detail {
                margin: 40px 0;
                background: #fff;
                border-radius: 12px;
                overflow: hidden;
                box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            }
            
            .td-detail-header {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                color: #fff;
                padding: 40px;
                display: grid;
                gap: 30px;
                align-items: center;
                grid-template-columns: 1fr;
            }
            
            @media (min-width: 1000px) {
                .td-detail-header {
                    grid-template-columns: 1.5fr 1fr;
                }
            }
            
            .td-detail-badges {
                display: flex;
                gap: 10px;
                margin-bottom: 15px;
                flex-wrap: wrap;
            }
            
            .td-detail-categorie,
            .td-detail-statut {
                display: inline-block;
                padding: 6px 12px;
                border-radius: 4px;
                font-size: 12px;
                font-weight: bold;
                text-transform: uppercase;
            }
            
            .td-detail-categorie {
                background: rgba(255,255,255,0.2);
            }
            
            .td-detail-statut {
                background: rgba(255,255,255,0.9);
                color: #2e7d32;
            }
            
            .td-detail-title {
                font-size: 40px;
                margin: 0 0 20px 0;
                line-height: 1.2;
                font-weight: 700;
            }
            
            @media (max-width: 999px) {
                .td-detail-title {
                    font-size: 28px;
                }
            }
            
            .td-detail-countdown {
                display: inline-flex;
                align-items: center;
                gap: 10px;
                padding: 12px 20px;
                background: rgba(255,255,255,0.15);
                border-radius: 8px;
                font-size: 18px;
                font-weight: bold;
            }
            
            @media (max-width: 999px) {
                .td-detail-countdown {
                    font-size: 16px;
                }
            }
            
            .td-countdown-label {
                font-size: 24px;
            }
            
            .td-detail-image {
                border-radius: 8px;
                overflow: hidden;
                box-shadow: 0 10px 30px rgba(0,0,0,0.3);
            }
            
            .td-detail-image img {
                width: 100%;
                height: auto;
                display: block;
            }
            
            .td-detail-body {
                padding: 40px;
                display: grid;
                gap: 30px;
                grid-template-columns: 1fr;
            }
            
            @media (min-width: 1000px) {
                .td-detail-body {
                    grid-template-columns: 2fr 1fr;
                }
            }
            
            .td-detail-section {
                margin-bottom: 30px;
            }
            
            .td-detail-section-title {
                font-size: 24px;
                margin: 0 0 20px 0;
                color: #333;
                border-bottom: 3px solid #667eea;
                padding-bottom: 10px;
            }
            
            @media (max-width: 999px) {
                .td-detail-section-title {
                    font-size: 20px;
                }
            }
            
            .td-detail-content {
                line-height: 1.8;
                color: #555;
            }
            
            .td-detail-programme img {
                width: 100%;
                height: auto;
                border-radius: 8px;
                box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            }
            
            .td-programme-pdf {
                display: flex;
                align-items: center;
                gap: 15px;
                padding: 20px;
                background: #f5f5f5;
                border-radius: 8px;
                text-decoration: none;
                color: #333;
                transition: all 0.3s;
            }
            
            .td-programme-pdf:hover {
                background: #e0e0e0;
                transform: translateY(-2px);
                box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            }
            
            .td-pdf-icon {
                font-size: 40px;
            }
            
            .td-pdf-text {
                font-weight: bold;
                font-size: 16px;
            }
            
            .td-detail-info-box,
            .td-detail-stats-box {
                background: #f9f9f9;
                border-radius: 8px;
                padding: 25px;
                margin-bottom: 20px;
            }
            
            .td-info-box-title {
                font-size: 18px;
                margin: 0 0 20px 0;
                color: #333;
                font-weight: 700;
            }
            
            .td-info-item {
                display: flex;
                gap: 15px;
                margin-bottom: 20px;
                align-items: flex-start;
            }
            
            .td-info-item:last-child {
                margin-bottom: 0;
            }
            
            .td-info-icon {
                font-size: 24px;
                flex-shrink: 0;
            }
            
            .td-info-content {
                display: flex;
                flex-direction: column;
                gap: 5px;
            }
            
            .td-info-content strong {
                color: #333;
                font-size: 14px;
            }
            
            .td-info-content span {
                color: #666;
                font-size: 15px;
            }
            
            .td-stat-item {
                text-align: center;
                padding: 20px;
                background: #fff;
                border-radius: 8px;
                margin-bottom: 15px;
            }
            
            .td-stat-item:last-child {
                margin-bottom: 0;
            }
            
            .td-stat-number {
                display: block;
                font-size: 36px;
                font-weight: bold;
                color: #667eea;
                margin-bottom: 5px;
            }
            
            .td-stat-label {
                display: block;
                font-size: 14px;
                color: #666;
            }
            
            .td-detail-btn {
                display: block;
                width: 100%;
                padding: 15px 20px;
                background: #667eea;
                color: #fff;
                text-align: center;
                text-decoration: none;
                border-radius: 8px;
                font-weight: bold;
                transition: all 0.3s;
            }
            
            .td-detail-btn:hover {
                background: #5568d3;
                transform: translateY(-2px);
                box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
            }
            
            .td-prochaine-detail-vide {
                padding: 60px 20px;
                text-align: center;
                background: #f5f5f5;
                border-radius: 12px;
                margin: 40px 0;
            }
            
            .td-prochaine-detail-vide p {
                font-size: 18px;
                color: #666;
                font-style: italic;
                margin: 0;
            }
        </style>
        <?php
    }
    wp_reset_postdata();
    
    return ob_get_clean();
}
