<?php

// Mettre à jour les catégories et statuts d'une rencontre
function td_rencontres_update_categories_and_statuts($post_id) {
    $date_evenement = get_post_meta($post_id, '_td_date_evenement', true);
    $date_fermeture_inscriptions = get_post_meta($post_id, '_td_date_fermeture_inscriptions', true);
    
    if (empty($date_evenement)) {
        return;
    }
    
    $date_event = strtotime($date_evenement);
    $date_aujourdhui = strtotime(date('Y-m-d'));
    
    // Récupérer les termes
    $term_a_venir = get_term_by('name', 'À venir', 'categorie_rencontre');
    $term_passee = get_term_by('name', 'Passée', 'categorie_rencontre');
    $term_inscriptions_ouvertes = get_term_by('name', 'Inscriptions ouvertes', 'categorie_rencontre');
    $term_inscriptions_fermees = get_term_by('name', 'Inscriptions fermées', 'categorie_rencontre');
    
    $categories_a_assigner = array();
    
    // Gérer la catégorie À venir / Passée
    if ($date_event < $date_aujourdhui) {
        if ($term_passee) {
            $categories_a_assigner[] = $term_passee->term_id;
        }
    } else {
        if ($term_a_venir) {
            $categories_a_assigner[] = $term_a_venir->term_id;
        }
    }
    
    // Gérer le statut des inscriptions
    if (!empty($date_fermeture_inscriptions)) {
        $date_fermeture = strtotime($date_fermeture_inscriptions);
        
        if ($date_fermeture < $date_aujourdhui) {
            if ($term_inscriptions_fermees) {
                $categories_a_assigner[] = $term_inscriptions_fermees->term_id;
            }
        } else {
            if ($term_inscriptions_ouvertes) {
                $categories_a_assigner[] = $term_inscriptions_ouvertes->term_id;
            }
        }
    } else {
        // Par défaut, inscriptions ouvertes
        if ($term_inscriptions_ouvertes) {
            $categories_a_assigner[] = $term_inscriptions_ouvertes->term_id;
        }
    }
    
    // Assigner toutes les catégories en une seule fois
    if (!empty($categories_a_assigner)) {
        wp_set_object_terms($post_id, $categories_a_assigner, 'categorie_rencontre', false);
    }
}

// Mettre à jour toutes les catégories et statuts quotidiennement
function td_rencontres_update_all_categories_and_statuts() {
    $rencontres = get_posts(array(
        'post_type' => 'rencontre',
        'posts_per_page' => -1,
        'post_status' => 'publish'
    ));
    
    foreach ($rencontres as $rencontre) {
        td_rencontres_update_categories_and_statuts($rencontre->ID);
    }
}

// Planifier la mise à jour quotidienne
if (!wp_next_scheduled('td_rencontres_daily_update')) {
    wp_schedule_event(time(), 'daily', 'td_rencontres_daily_update');
}
add_action('td_rencontres_daily_update', 'td_rencontres_update_all_categories_and_statuts');