<?php
/**
 * Template pour afficher la page 404
 *
 * @package WPCNRS
 */

get_header();
?>

<main id="main" class="site-main">
    <div class="container">
        <div class="content-area">
            <section class="error-404 not-found">
                <header class="page-header">
                    <h1 class="page-title"><?php esc_html_e('Oups ! Cette page est introuvable.', 'wpcnrs'); ?></h1>
                </header>
                
                <div class="page-content">
                    <p><?php esc_html_e('Il semble que rien n\'a été trouvé à cet emplacement. Essayez peut-être une recherche ?', 'wpcnrs'); ?></p>
                    
                    <?php get_search_form(); ?>
                    
                    <h2><?php esc_html_e('Essayez ces liens :', 'wpcnrs'); ?></h2>
                    
                    <div class="widget">
                        <h3 class="widget-title"><?php esc_html_e('Articles récents', 'wpcnrs'); ?></h3>
                        <ul>
                            <?php
                            wp_list_pages(array(
                                'title_li' => '',
                                'number' => 5
                            ));
                            ?>
                        </ul>
                    </div>
                    
                    <div class="widget">
                        <h3 class="widget-title"><?php esc_html_e('Catégories', 'wpcnrs'); ?></h3>
                        <ul>
                            <?php
                            wp_list_categories(array(
                                'title_li' => '',
                                'show_count' => 1,
                                'number' => 10
                            ));
                            ?>
                        </ul>
                    </div>
                </div>
            </section>
        </div>
        
        <?php get_sidebar(); ?>
    </div>
</main>

<?php
get_footer();
