<?php
/**
 * Template pour afficher les archives
 *
 * @package WPCNRS
 */

get_header();
?>

<main id="main" class="site-main">
    <div class="container">
        <div class="content-area">
            <?php
            if (have_posts()) {
                ?>
                <header class="page-header">
                    <?php
                    the_archive_title('<h1 class="page-title">', '</h1>');
                    the_archive_description('<div class="archive-description">', '</div>');
                    ?>
                </header>
                <?php
                
                while (have_posts()) {
                    the_post();
                    get_template_part('template-parts/content', get_post_type());
                }
                
                the_posts_navigation(array(
                    'prev_text' => __('&larr; Articles précédents', 'wpcnrs'),
                    'next_text' => __('Articles suivants &rarr;', 'wpcnrs')
                ));
            } else {
                get_template_part('template-parts/content', 'none');
            }
            ?>
        </div>
        
        <?php get_sidebar(); ?>
    </div>
</main>

<?php
get_footer();
