<?php
/**
 * Pied de page du site
 *
 * @package WPCNRS
 */
?>

    <footer id="colophon" class="site-footer">
        <div class="container">
            <?php
            if (is_active_sidebar('footer-1')) {
                ?>
                <div class="footer-widgets">
                    <?php dynamic_sidebar('footer-1'); ?>
                </div>
                <?php
            }
            ?>
            
            <?php
            if (has_nav_menu('footer')) {
                ?>
                <nav class="footer-navigation" role="navigation" aria-label="<?php esc_attr_e('Menu pied de page', 'wpcnrs'); ?>">
                    <?php
                    wp_nav_menu(array(
                        'theme_location' => 'footer',
                        'menu_id' => 'footer-menu',
                        'container' => false,
                        'depth' => 1,
                        'fallback_cb' => false
                    ));
                    ?>
                </nav>
                <?php
            }
            ?>
            
            <div class="site-info">
                <p>&copy; <?php echo date('Y'); ?> <?php bloginfo('name'); ?>. <?php _e('Tous droits réservés.', 'wpcnrs'); ?></p>
            </div>
        </div>
    </footer>
</div>

<?php wp_footer(); ?>
</body>
</html>
