document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.laboratoire__item').forEach(function(item) {
        // Cherche le bloc meta-field qui contient l'URL
        var valueDiv = item.querySelector('.td_lab_lien__url .value');
        if (!valueDiv) return;

        var url = valueDiv.textContent.trim();
        if (!url) return;

        // Ajoute le clic sur le parent
        item.addEventListener('click', function() {
            window.open(url, '_blank');
        });

        // Crée le masque s'il n'existe pas déjà
        if (!item.querySelector('.laboratoire__mask')) {
            var mask = document.createElement('div');
            mask.className = 'laboratoire__mask';
            mask.textContent = 'Accéder au site';
            item.appendChild(mask);
        }
    });
});
