<?php
/**
 * Template pour afficher les résultats de recherche
 *
 * @package WPCNRS
 */

get_header();
?>

<main id="main" class="site-main">
    <div class="container">
        <div class="content-area">
            <?php
            if (have_posts()) {
                ?>
                <header class="page-header">
                    <h1 class="page-title">
                        <?php
                        printf(
                            esc_html__('Résultats de recherche pour : %s', 'wpcnrs'),
                            '<span>' . get_search_query() . '</span>'
                        );
                        ?>
                    </h1>
                </header>
                <?php
                
                while (have_posts()) {
                    the_post();
                    get_template_part('template-parts/content', 'search');
                }
                
                the_posts_navigation(array(
                    'prev_text' => __('&larr; Résultats précédents', 'wpcnrs'),
                    'next_text' => __('Résultats suivants &rarr;', 'wpcnrs')
                ));
            } else {
                get_template_part('template-parts/content', 'none');
            }
            ?>
        </div>
        
        <?php get_sidebar(); ?>
    </div>
</main>

<?php
get_footer();
