<?php
/**
 * Template pour afficher le formulaire de recherche
 *
 * @package WPCNRS
 */
?>

<form role="search" method="get" class="search-form" action="<?php echo esc_url(home_url('/')); ?>">
    <label>
        <span class="screen-reader-text"><?php echo _x('Rechercher :', 'label', 'wpcnrs'); ?></span>
        <input type="search" class="search-field" placeholder="<?php echo esc_attr_x('Rechercher &hellip;', 'placeholder', 'wpcnrs'); ?>" value="<?php echo get_search_query(); ?>" name="s" />
    </label>
    <button type="submit" class="search-submit">
        <?php echo _x('Rechercher', 'submit button', 'wpcnrs'); ?>
    </button>
</form>
