<?php
/**
 * Template pour afficher un article unique
 *
 * @package WPCNRS
 */

get_header();
?>

<main id="main" class="site-main">
    <div class="container">
        <div class="content-area">
            <?php
            while (have_posts()) {
                the_post();
                get_template_part('template-parts/content', 'single');
                
                the_post_navigation(array(
                    'prev_text' => '<span class="nav-subtitle">' . esc_html__('Article précédent:', 'wpcnrs') . '</span> <span class="nav-title">%title</span>',
                    'next_text' => '<span class="nav-subtitle">' . esc_html__('Article suivant:', 'wpcnrs') . '</span> <span class="nav-title">%title</span>'
                ));
                
                if (comments_open() || get_comments_number()) {
                    comments_template();
                }
            }
            ?>
        </div>
        
        <?php get_sidebar(); ?>
    </div>
</main>

<?php
get_footer();
