<?php
/**
 * Template part pour afficher un message quand aucun contenu n\'est trouvé
 *
 * @package WPCNRS
 */
?>

<section class="no-results not-found article-wrapper">
    <header class="page-header">
        <h1 class="page-title"><?php esc_html_e('Aucun contenu trouvé', 'wpcnrs'); ?></h1>
    </header>
    
    <div class="page-content">
        <?php
        if (is_home() && current_user_can('publish_posts')) {
            ?>
            <p>
                <?php
                printf(
                    wp_kses(
                        __('Prêt à publier votre premier article ? <a href="%1$s">Commencez ici</a>.', 'wpcnrs'),
                        array('a' => array('href' => array()))
                    ),
                    esc_url(admin_url('post-new.php'))
                );
                ?>
            </p>
            <?php
        } elseif (is_search()) {
            ?>
            <p><?php esc_html_e('Désolé, aucun résultat ne correspond à votre recherche. Veuillez réessayer avec d\'autres mots-clés.', 'wpcnrs'); ?></p>
            <?php
            get_search_form();
        } else {
            ?>
            <p><?php esc_html_e('Il semble que nous ne puissions pas trouver ce que vous recherchez. Peut-être qu\'une recherche pourrait vous aider.', 'wpcnrs'); ?></p>
            <?php
            get_search_form();
        }
        ?>
    </div>
</section>
