<?php
/**
 * Template part pour afficher une page
 *
 * @package WPCNRS
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('article-wrapper'); ?>>
    <?php
    if (has_post_thumbnail()) {
        ?>
        <div class="post-thumbnail">
            <?php the_post_thumbnail('full', array('alt' => get_the_title())); ?>
        </div>
        <?php
    }
    ?>
    
    <header class="entry-header">
        <?php the_title('<h1 class="entry-title">', '</h1>'); ?>
    </header>
    
    <div class="entry-content">
        <?php
        the_content();
        
        wp_link_pages(array(
            'before' => '<div class="page-links">' . esc_html__('Pages :', 'wpcnrs'),
            'after' => '</div>'
        ));
        ?>
    </div>
    
    <?php
    if (get_edit_post_link()) {
        ?>
        <footer class="entry-footer">
            <?php
            edit_post_link(
                sprintf(
                    wp_kses(
                        __('Modifier <span class="screen-reader-text">%s</span>', 'wpcnrs'),
                        array('span' => array('class' => array()))
                    ),
                    get_the_title()
                ),
                '<span class="edit-link">',
                '</span>'
            );
            ?>
        </footer>
        <?php
    }
    ?>
</article>
