<?php
/**
 * Template part pour afficher les résultats de recherche
 *
 * @package WPCNRS
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('article-wrapper'); ?>>
    <header class="entry-header">
        <?php the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>'); ?>
        
        <?php
        if ('post' === get_post_type()) {
            ?>
            <div class="entry-meta">
                <?php
                td_wpcnrs_posted_on();
                td_wpcnrs_posted_by();
                ?>
            </div>
            <?php
        }
        ?>
    </header>
    
    <div class="entry-summary">
        <?php the_excerpt(); ?>
    </div>
    
    <footer class="entry-footer">
        <a href="<?php the_permalink(); ?>" class="more-link">
            <?php echo esc_html__('Lire la suite', 'wpcnrs'); ?> &rarr;
        </a>
    </footer>
</article>
