<?php
/**
 * Template part pour afficher un article unique
 *
 * @package WPCNRS
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('article-wrapper'); ?>>
    <?php
    if (has_post_thumbnail()) {
        ?>
        <div class="post-thumbnail">
            <?php the_post_thumbnail('full', array('alt' => get_the_title())); ?>
        </div>
        <?php
    }
    ?>
    
    <header class="entry-header">
        <?php the_title('<h1 class="entry-title">', '</h1>'); ?>
        
        <div class="entry-meta">
            <?php
            td_wpcnrs_posted_on();
            td_wpcnrs_posted_by();
            ?>
        </div>
    </header>
    
    <div class="entry-content">
        <?php
        the_content();
        
        wp_link_pages(array(
            'before' => '<div class="page-links">' . esc_html__('Pages :', 'wpcnrs'),
            'after' => '</div>'
        ));
        ?>
    </div>
    
    <footer class="entry-footer">
        <?php td_wpcnrs_entry_footer(); ?>
    </footer>
</article>
