<?php
/**
 * Template part pour afficher les articles
 *
 * @package WPCNRS
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('article-wrapper'); ?>>
    <?php
    if (has_post_thumbnail()) {
        ?>
        <div class="post-thumbnail">
            <a href="<?php the_permalink(); ?>">
                <?php the_post_thumbnail('wpcnrs-featured', array('alt' => get_the_title())); ?>
            </a>
        </div>
        <?php
    }
    ?>
    
    <header class="entry-header">
        <?php
        if (is_singular()) {
            the_title('<h1 class="entry-title">', '</h1>');
        } else {
            the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>');
        }
        
        if ('post' === get_post_type()) {
            ?>
            <div class="entry-meta">
                <?php
                td_wpcnrs_posted_on();
                td_wpcnrs_posted_by();
                ?>
            </div>
            <?php
        }
        ?>
    </header>
    
    <div class="entry-content">
        <?php
        if (is_singular()) {
            the_content();
            
            wp_link_pages(array(
                'before' => '<div class="page-links">' . esc_html__('Pages :', 'wpcnrs'),
                'after' => '</div>'
            ));
        } else {
            the_excerpt();
            ?>
            <a href="<?php the_permalink(); ?>" class="more-link">
                <?php echo esc_html__('Lire la suite', 'wpcnrs'); ?> &rarr;
            </a>
            <?php
        }
        ?>
    </div>
    
    <?php
    if (is_singular() && 'post' === get_post_type()) {
        ?>
        <footer class="entry-footer">
            <?php td_wpcnrs_entry_footer(); ?>
        </footer>
        <?php
    }
    ?>
</article>
